#!/usr/bin/perl -w
#
# un-black.pl		par bernard FRIT <bernard@frit.net> le 3 fevrier 2005

# v.0.2

use strict;

# nom du programme
my($PROG) = 'un-black.pl' ;

# version du programme
my($VER) = '0.2' ;

################## Configuration ############################################################

# dure en minutes du blacklistage ex : pour 15 min -> 15 / (24 * 60) 
my($DELAY) = 600 / (24 * 60);

# path des Ips en cours d'analyse
my($TMP) = '/root/tmp/Ips' ;

# path des Ips blacklistes
my($BLACK) = '/root/tmp/Ips-black' ;

# path d'Iptables
my($IPTABLES) = '/sbin/iptables';

################## Fin de Config ############################################################


my($HOST) = `uname -n` ;
chop($HOST);
$HOST =~ /^(.+)\.(.+)\.(.+)/ ;
$HOST = $1 ;

my($INFO) = " $HOST $PROG v.$VER($$): ";

print scalar localtime,$INFO,"Initializing...\n";

my(@black_list) = `ls -1 $BLACK` ;
my(@ip_list) = `ls -1 $TMP` ;

my ($file) ;

foreach $file (@black_list) {
    chop($file);
    if (-M("$BLACK/$file")) {
	unlink("$BLACK/$file") ;
	delIp($file) ;
	print scalar localtime,$INFO,"$file restablished\n";
    }
}
            
foreach $file (@ip_list) {
    chop($file);
    if (-M("$TMP/$file")) {
	unlink("$TMP/$file") ;
	print scalar localtime,$INFO,"$file reinitialized\n";
    }
}
	

sub delIp {
   my($ip) = @_;

   my(@args) = ($IPTABLES,
                '-D',
                'INPUT', '--source',
                $ip,
                '-j', 'REJECT', '--reject-with', 'icmp-host-prohibited');

#   print "system(@args)\n";

    system(@args) ;

}