using System;
using System.IO;
using System.Reflection;
using  NUnit.Framework;
using CookComputing.XmlRpc;

namespace ntest
{       
  interface ITest
  {
    [XmlRpcMethod]
    string Method1(int x);
  }

  [TestFixture]
  public class ProxyGenTest
  {
    public void testMethod1()
    {
      ITest proxy = (ITest)XmlRpcProxyGen.Create(typeof(ITest));
      XmlRpcClientProtocol cp = (XmlRpcClientProtocol)proxy;
    }

    interface IParent 
    {
      [XmlRpcMethod]
      string Foo(int x);
    }

    interface IChild : IParent
    {
      [XmlRpcMethod]
      string Bar(int x);
    }

    public void testInheritedInterface()
    {
      // Test problem reported by Sean Rohead. This will throw an exception 
      // if method Foo in the base class Parent is not implemented
      IChild proxy = (IChild)XmlRpcProxyGen.Create(typeof(IChild));
    }
  }

}