using System;
using System.IO;
using System.Xml;
using System.Reflection;
using NUnit.Framework;
using CookComputing.XmlRpc;


class XmlRpcStruct1 : XmlRpcStruct
{
  public int mi;
}

namespace ntest 
{

  [TestFixture]
  public class OptionalDeserializeTest
  {
    struct Struct1
    {
      public int mi;
      public string ms;
      public bool mb;
      public double md;
      public DateTime mdt;
      public byte[] mb64;
      public int[] ma;
      public XmlRpcInt xi;
      public XmlRpcBoolean xb;
      public XmlRpcDouble xd;
      public XmlRpcDateTime xdt;
      public XmlRpcStruct xstr;
    }

    [XmlRpcMissingMapping(MappingAction.Ignore)]
      struct Struct2
    {
      public int mi;
      public string ms;
      public bool mb;
      public double md;
      public DateTime mdt;
      public byte[] mb64;
      public int[] ma;
      public XmlRpcInt xi;
      public XmlRpcBoolean xb;
      public XmlRpcDouble xd;
      public XmlRpcDateTime xdt;
      public XmlRpcStruct xstr;
    }

    struct Struct3
    {
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public int mi;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public string ms;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public bool mb;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public double md;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public DateTime mdt;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public byte[] mb64;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public int[] ma;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcInt xi;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcBoolean xb;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcDouble xd;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcDateTime xdt;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcStruct xstr;
    }

    [XmlRpcMissingMapping(MappingAction.Error)]
      struct Struct4
    {
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public int mi;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public string ms;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public bool mb;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public double md;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public DateTime mdt;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public byte[] mb64;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public int[] ma;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcInt xi;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcBoolean xb;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcDouble xd;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcDateTime xdt;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public XmlRpcStruct xstr;
    }

    public void testStruct1_AllMissing_Error()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?><value><struct></struct></value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(Struct1), MappingAction.Error, 
          out parsedType, out parsedArrayType);
        Assert.Fail("didn't detect missing members");
      }
      catch (XmlRpcTypeMismatchException)
      {
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }    
  
    public void testStruct1_AllMissing_Ignore()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?><value><struct></struct></value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(Struct1), MappingAction.Ignore, 
          out parsedType, out parsedArrayType);
        Assert.IsTrue(obj is Struct1, "obj is Struct1");
        Assert.AreEqual(0, ((Struct1)obj).mi, "int member");
        Assert.AreEqual(null, ((Struct1)obj).ms, "string member");
        Assert.AreEqual(false, ((Struct1)obj).mb, "boolean member");
        Assert.AreEqual(0.0, ((Struct1)obj).md, "double member");
        Assert.AreEqual(new DateTime(), ((Struct1)obj).mdt, "dateTime member");
        Assert.AreEqual(null, ((Struct1)obj).mb64, "base64 member"); 
        Assert.AreEqual(null, ((Struct1)obj).ma, "array member"); 
        Assert.AreEqual(null, ((Struct1)obj).xi, "XmlRpcInt member"); 
        Assert.AreEqual(null, ((Struct1)obj).xb, "XmlRpcBoolean member"); 
        Assert.AreEqual(null, ((Struct1)obj).xd, "XmlRpcDouble member"); 
        Assert.AreEqual(null, ((Struct1)obj).xdt, "XmlRpcDateTime member");                
        Assert.AreEqual(null, ((Struct1)obj).xstr, "XmlRpcStructTime member");                
      }
      catch (XmlRpcTypeMismatchException mmex)
      {
        Assert.Fail("unexpected XmlRpcTypeMismatchException: " + mmex.Message);
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }
  
    public void testStruct2_AllMissing_ErrorStructIgnore()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?><value><struct></struct></value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(Struct2), MappingAction.Error, 
          out parsedType, out parsedArrayType);
        Assert.IsTrue(obj is Struct2, "obj is Struct2");
        Assert.AreEqual(0, ((Struct2)obj).mi, "int member");
        Assert.AreEqual(null, ((Struct2)obj).ms, "string member");
        Assert.AreEqual(false, ((Struct2)obj).mb,"boolean member");
        Assert.AreEqual(0.0, ((Struct2)obj).md, "double member");
        Assert.AreEqual(new DateTime(), ((Struct2)obj).mdt, "dateTime member");
        Assert.AreEqual(null, ((Struct2)obj).mb64, "base64 member");        
        Assert.AreEqual(null, ((Struct2)obj).ma, "array member"); 
        Assert.AreEqual(null, ((Struct2)obj).xi, "XmlRpcInt member"); 
        Assert.AreEqual(null, ((Struct2)obj).xb, "XmlRpcBoolean member"); 
        Assert.AreEqual(null, ((Struct2)obj).xd, "XmlRpcDouble member"); 
        Assert.AreEqual(null, ((Struct2)obj).xdt, "XmlRpcDateTime member");                
        Assert.AreEqual(null, ((Struct2)obj).xstr, "XmlRpcStructTime member");                
      }
      catch (XmlRpcTypeMismatchException mmex)
      {
        Assert.Fail("unexpected XmlRpcTypeMismatchException: " + mmex.Message);
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }

    public void testStruct3_AllMissing_ErrorMemberIgnore()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?><value><struct></struct></value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(Struct3), MappingAction.Error, 
          out parsedType, out parsedArrayType);
        Assert.IsTrue(obj is Struct3, "obj is Struct3");
        Assert.AreEqual(0, ((Struct3)obj).mi, "int member");
        Assert.AreEqual(null, ((Struct3)obj).ms, "string member");
        Assert.AreEqual(false, ((Struct3)obj).mb, "boolean member");
        Assert.AreEqual(0.0, ((Struct3)obj).md, "double member");
        Assert.AreEqual(new DateTime(), ((Struct3)obj).mdt, "dateTime member");
        Assert.AreEqual(null, ((Struct3)obj).mb64, "base64 member");        
        Assert.AreEqual(null, ((Struct3)obj).ma, "array member"); 
        Assert.AreEqual(null, ((Struct3)obj).xi, "XmlRpcInt member"); 
        Assert.AreEqual(null, ((Struct3)obj).xb, "XmlRpcBoolean member"); 
        Assert.AreEqual(null, ((Struct3)obj).xd, "XmlRpcDouble member"); 
        Assert.AreEqual(null, ((Struct3)obj).xdt, "XmlRpcDateTime member");                
        Assert.AreEqual(null, ((Struct3)obj).xstr, "XmlRpcStructTime member");                
      }
      catch (XmlRpcTypeMismatchException mmex)
      {
        Assert.Fail("unexpected XmlRpcTypeMismatchException: " 
          + mmex.Message);
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }

    public void testStruct4_AllMissing_ErrorStructErrorMemberIgnore()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?><value><struct></struct></value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(Struct4), MappingAction.Error, 
          out parsedType, out parsedArrayType);
        Assert.IsTrue(obj is Struct4, "obj is Struct4");
        Assert.AreEqual(0, ((Struct4)obj).mi, "int member");
        Assert.AreEqual(null, ((Struct4)obj).ms, "string member");
        Assert.AreEqual(false, ((Struct4)obj).mb, "boolean member");
        Assert.AreEqual(0.0, ((Struct4)obj).md, "double member");
        Assert.AreEqual(new DateTime(), ((Struct4)obj).mdt, "dateTime member");
        Assert.AreEqual(null, ((Struct4)obj).mb64, "base64 member");        
        Assert.AreEqual(null, ((Struct4)obj).ma, "array member"); 
        Assert.AreEqual(null, ((Struct4)obj).xi, "XmlRpcInt member"); 
        Assert.AreEqual(null, ((Struct4)obj).xb, "XmlRpcBoolean member"); 
        Assert.AreEqual(null, ((Struct4)obj).xd, "XmlRpcDouble member"); 
        Assert.AreEqual(null, ((Struct4)obj).xdt, "XmlRpcDateTime member");                
        Assert.AreEqual(null, ((Struct4)obj).xstr, "XmlRpcStructTime member");                
      }
      catch (XmlRpcTypeMismatchException mmex)
      {
        Assert.Fail("unexpected XmlRpcTypeMismatchException: " 
          + mmex.Message);
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }
      
   public void testStruct4_AllMissing_IgnoreStructErrorMemberIgnore()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?><value><struct></struct></value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(Struct4), MappingAction.Ignore, 
          out parsedType, out parsedArrayType);
        Assert.IsTrue(obj is Struct4, "obj is Struct4");
        Assert.AreEqual(0, ((Struct4)obj).mi,"int member");
        Assert.AreEqual(null, ((Struct4)obj).ms, "string member");
        Assert.AreEqual(false, ((Struct4)obj).mb, "boolean member");
        Assert.AreEqual(0.0, ((Struct4)obj).md, "double member");
        Assert.AreEqual(new DateTime(), ((Struct4)obj).mdt, "dateTime member");
        Assert.AreEqual(null, ((Struct4)obj).mb64, "base64 member");        
        Assert.AreEqual(null, ((Struct4)obj).ma, "array member"); 
        Assert.AreEqual(null, ((Struct4)obj).xi, "XmlRpcInt member"); 
        Assert.AreEqual(null, ((Struct4)obj).xb, "XmlRpcBoolean member"); 
        Assert.AreEqual(null, ((Struct4)obj).xd, "XmlRpcDouble member"); 
        Assert.AreEqual(null, ((Struct4)obj).xdt, "XmlRpcDateTime member");                
        Assert.AreEqual(null, ((Struct4)obj).xstr, "XmlRpcStructTime member");                
      }
      catch (XmlRpcTypeMismatchException mmex)
      {
        Assert.Fail("unexpected XmlRpcTypeMismatchException: " 
          + mmex.Message);
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }

    [XmlRpcMissingMapping(MappingAction.Ignore)]
    struct StructOuter1
    {
      public StructInner1 mstruct;
    }

    struct StructInner1
    {
      public int mi;
    }

    public void testNoInnerStructOverrideIgnoreError()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?>
      <value>
        <struct>
          <member>
            <name>mstruct</name>
            <value><struct></struct></value>
          </member>
        </struct>
      </value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(StructOuter1), MappingAction.Error, 
          out parsedType, out parsedArrayType);
        Assert.Fail("didn't detect missing members");
      }
      catch (XmlRpcTypeMismatchException)
      {
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }

    [XmlRpcMissingMapping(MappingAction.Error)]
      struct StructOuter2
    {
      public StructInner2 mstruct;
    }

    struct StructInner2
    {
      public int mi;
    }

    public void testNoInnerStructOverrideErrorIgnore()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?>
      <value>
        <struct>
          <member>
            <name>mstruct</name>
            <value><struct></struct></value>
          </member>
        </struct>
      </value>";
      try
      {
        object obj = Utils.Parse(xml, typeof(StructOuter2), 
          MappingAction.Ignore, 
          out parsedType, out parsedArrayType);
      }
      catch (XmlRpcTypeMismatchException)
      {
        Assert.Fail("falsely detected missing member in inner struct");
      }
      catch(Exception ex)
      {
        Assert.Fail("unexpected exception: " + ex.Message);
      }
    }

    //-------------------------------------------------------------------------/
    struct StructHung
    {
      int _pi;
      string _ps;

      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public int mi;
      public string ms;
      [XmlRpcMissingMapping(MappingAction.Ignore)]
      public int pi { get { return _pi; } set { _pi = value; } }
      public string ps { get { return _ps; } set { _ps = value; } }
    }

    public void testStructHung()
    {
      Type parsedType, parsedArrayType;
      string xml = @"<?xml version=""1.0"" ?>
      <value>
        <struct>
          <member>
            <name>mi</name>
            <value><int></int></value>
          </member>
          <member>
            <name>ms</name>
            <value><string></string></value>
          </member>
          <member>
            <name>ps</name>
            <value><string>property</string></value>
          </member>
        </struct>
      </value>";
      object obj = Utils.Parse(xml, typeof(StructHung), MappingAction.Error, 
        out parsedType, out parsedArrayType);
      Assert.IsTrue(obj is StructHung);
      StructHung strct = (StructHung)obj;
      Assert.AreEqual(strct.mi, 0);
      Assert.AreEqual(strct.ms, "");
      Assert.AreEqual(strct.pi, 0);
      Assert.AreEqual(strct.ps, "property");
    }
  }
}